import pandas as pd  
import pickle
from decision_company import read_csv_file, select_data_types, get_columns, get_dummies

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Identify categorical variables  
categorical_columns = get_columns(select_data_types(credit_customers,['object']))  
  
# Initialize an empty list to store nominal categorical columns  
nominal_categorical_columns = list(categorical_columns)  
  
# Suggest encoding methods  
print("Suggested encoding methods:")  
print("1. One-hot encoding for nominal categorical variables:")  
for col in nominal_categorical_columns:  
    print("   -", col)  
  
# Example code for one-hot encoding  
credit_customers_encoded = get_dummies(credit_customers, columns=nominal_categorical_columns)  
print("\nData after one-hot encoding:\n", credit_customers_encoded.head())  
  
# Save the encoded data to a file  
pickle.dump(credit_customers_encoded, open("./ref_result/credit_customers_encoded.pkl", "wb"))  
